/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

class AffirmativeActionCanvas
extends Canvas
implements MouseMotionListener,
MouseListener {
    AffirmativeAction m_Parent;
    Image m_Image;
    Graphics m_Graph;
    Image m_BImage;
    Graphics m_BGraph;
    private Vector m_Nodes;
    private Vector m_Links;
    private Stack Items;
    private int m_r = 6;
    private int m_R = 10;
    Color[] Colors = new Color[]{Color.white, Color.black};
    Color DarkGreen = Color.green.darker().darker();
    static final String[] m_Results = new String[]{"Please reset the board.", "Loops not allowed."};
    String m_Announce;
    boolean bInitialized = false;
    boolean bDragging = false;
    boolean bMoving = false;
    boolean ShowDegrees = false;
    boolean AllowLoops = false;
    private Color ColorDragging = Color.magenta;
    private Color ColorText;
    private Point m_LU = new Point(0, 0);
    private Point m_RB = new Point(0, 0);
    private int m_Num = 0;
    private int m_LUN;
    private int m_RBN;
    private int m_bigspace;
    int extra = 1;

    public AffirmativeActionCanvas(AffirmativeAction affirmativeAction) {
        this.m_Parent = affirmativeAction;
        try {
            this.setBackground(Color.white);
            this.setForeground(Color.black);
        }
        catch (Exception exception) {
            this.setBackground(Color.lightGray);
            this.setForeground(Color.black);
        }
        this.ColorText = this.getForeground();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void init() {
        this.m_Nodes = new Vector();
        this.m_Links = new Vector();
        this.Items = new Stack();
        Dimension dimension = this.getSize();
        this.m_Image = this.createImage(dimension.width, dimension.height);
        this.m_Graph = this.m_Image.getGraphics();
        try {
            ((Graphics2D)this.m_Graph).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        catch (Exception exception) {
            this.m_Graph.dispose();
            this.m_Image = this.createImage(dimension.width, dimension.height);
            this.m_Graph = this.m_Image.getGraphics();
        }
        this.m_BImage = this.createImage(dimension.width, dimension.height);
        this.m_BGraph = this.m_BImage.getGraphics();
        try {
            ((Graphics2D)this.m_BGraph).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        catch (Exception exception) {
            this.m_BGraph.dispose();
            this.m_BImage = this.createImage(dimension.width, dimension.height);
            this.m_BGraph = this.m_BImage.getGraphics();
        }
        Font font = new Font("Verdana,Arial", 1, 15);
        this.m_Graph.setFont(font);
        this.m_BGraph.setFont(font);
        FontMetrics fontMetrics = this.m_Graph.getFontMetrics();
        this.InitReset();
        this.bInitialized = true;
    }

    public void paint(Graphics graphics) {
        if (!this.bInitialized) {
            this.init();
        }
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        this.m_Graph.drawImage(this.m_BImage, 0, 0, null);
        if (this.bDragging) {
            this.m_Graph.setColor(this.ColorDragging);
            this.m_Graph.drawLine(this.m_LU.x, this.m_LU.y, this.m_RB.x, this.m_RB.y);
        }
        Dimension dimension = this.getSize();
        if (this.m_Announce != null) {
            FontMetrics fontMetrics = this.m_Graph.getFontMetrics();
            this.m_Graph.setColor(this.ColorText);
            this.m_Graph.drawString(this.m_Announce, (dimension.width - fontMetrics.stringWidth(this.m_Announce)) / 2, dimension.height - 6);
            this.m_Announce = null;
        }
        if (this.ShowDegrees) {
            this.ShowDegrees(this.m_Graph);
        }
        this.m_Graph.setColor(this.getForeground());
        this.m_Graph.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        graphics.drawImage(this.m_Image, 0, 0, null);
    }

    void ShowDegrees(Graphics graphics) {
        int[][] nArray = this.CollectBalanceInfo();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getAscent() - fontMetrics.getDescent() + 2 * this.extra;
        for (int i = 0; i < this.m_Nodes.size(); ++i) {
            int n2;
            int[] nArray2 = (int[])this.m_Nodes.elementAt(i);
            int n3 = nArray2[3];
            int n4 = nArray[i][n3];
            String string = n4 > (n2 = nArray[i][1 - n3]) ? " > " : (n4 == n2 ? " = " : " < ");
            String string2 = "" + n4 + string + n2;
            int n5 = fontMetrics.stringWidth(string2);
            int n6 = nArray2[0] - n5 / 2;
            int n7 = nArray2[1] - this.m_r - 1;
            graphics.setColor(this.DarkGreen);
            graphics.fillRect(n6 - this.extra, n7 - n, n5 + 2 * this.extra, n);
            graphics.setColor(this.Colors[n3]);
            String string3 = "" + n4;
            graphics.drawString(string3, n6, n7 - this.extra);
            n6 += fontMetrics.stringWidth(string3);
            string3 = string;
            graphics.setColor(Color.orange);
            graphics.drawString(string3, n6, n7 - this.extra);
            n6 += fontMetrics.stringWidth(string3);
            string3 = "" + n2;
            graphics.setColor(this.Colors[1 - n3]);
            graphics.drawString(string3, n6, n7 - this.extra);
        }
    }

    private int[][] CollectBalanceInfo() {
        int[][] nArray = new int[this.m_Nodes.size()][2];
        for (int i = 0; i < this.m_Links.size(); ++i) {
            int[] nArray2 = (int[])this.m_Links.elementAt(i);
            int[] nArray3 = (int[])this.m_Nodes.elementAt(nArray2[0]);
            int[] nArray4 = (int[])this.m_Nodes.elementAt(nArray2[1]);
            int[] nArray5 = nArray[nArray2[0]];
            int n = nArray4[3];
            nArray5[n] = nArray5[n] + nArray2[2];
            int[] nArray6 = nArray[nArray2[1]];
            int n2 = nArray3[3];
            nArray6[n2] = nArray6[n2] + nArray2[2];
        }
        return nArray;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Dimension dimension = this.getSize();
        if (this.bMoving) {
            this.m_LUN = this.FindNearest(mouseEvent.getX(), mouseEvent.getY());
            if (this.m_LUN == -1) {
                return;
            }
            this.repaint();
        } else {
            this.m_LUN = this.FindNearest(mouseEvent.getX(), mouseEvent.getY());
            if (this.m_LUN == -1) {
                this.m_LUN = this.m_Nodes.size();
                int[] nArray = new int[]{mouseEvent.getX(), mouseEvent.getY(), 0, 0};
                this.m_Nodes.addElement(nArray);
            }
            this.m_LU.x = ((int[])this.m_Nodes.elementAt(this.m_LUN))[0];
            this.m_LU.y = ((int[])this.m_Nodes.elementAt(this.m_LUN))[1];
            int[] nArray = (int[])this.m_Nodes.elementAt(this.m_LUN);
            nArray[2] = nArray[2] + 1;
            this.bDragging = true;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.bMoving) {
            if (this.m_LUN != -1) {
                int[] nArray = (int[])this.m_Nodes.elementAt(this.m_LUN);
                nArray[0] = mouseEvent.getX();
                nArray[1] = mouseEvent.getY();
                this.DrawFixed(this.m_BGraph);
                this.repaint();
            }
        } else if (this.bDragging) {
            this.m_RB.x = mouseEvent.getX();
            this.m_RB.y = mouseEvent.getY();
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Dimension dimension = this.getSize();
        if (this.bMoving) {
            if (this.m_LUN != -1) {
                int[] nArray = (int[])this.m_Nodes.elementAt(this.m_LUN);
                nArray[0] = mouseEvent.getX();
                nArray[1] = mouseEvent.getY();
                this.DrawFixed(this.m_BGraph);
                this.repaint();
            }
        } else if (this.bDragging) {
            this.m_RBN = this.FindNearest(mouseEvent.getX(), mouseEvent.getY());
            if (this.m_RBN == -1) {
                this.m_RBN = this.m_Nodes.size();
                int[] nArray = new int[]{mouseEvent.getX(), mouseEvent.getY(), 0, 0};
                this.m_Nodes.addElement(nArray);
            }
            int[] nArray = (int[])this.m_Nodes.elementAt(this.m_RBN);
            nArray[2] = nArray[2] + 1;
            this.AddLink();
            if (!this.AllowLoops && this.m_LUN == this.m_RBN) {
                this.Pop();
            }
        }
        this.bDragging = false;
        this.DrawFixed(this.m_BGraph);
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.m_LUN != -1) {
            try {
                int[] nArray = (int[])this.m_Nodes.elementAt(this.m_LUN);
                nArray[3] = 1 - nArray[3];
                this.DrawFixed(this.m_BGraph);
                this.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void AddLink() {
        this.AddLink(this.m_LUN, this.m_RBN);
    }

    private void AddLink(int n, int n2) {
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        for (int i = 0; i < this.m_Links.size(); ++i) {
            int[] nArray = (int[])this.m_Links.elementAt(i);
            if (nArray[0] != n || nArray[1] != n2) continue;
            nArray[2] = nArray[2] + 1;
            this.Items.push(new Integer(i));
            return;
        }
        int[] nArray = new int[]{n, n2, 1};
        this.Items.push(new Integer(this.m_Links.size()));
        this.m_Links.addElement(nArray);
        this.m_Parent.m_panel.Pop.setEnabled(true);
        this.m_Parent.m_panel.Move.setEnabled(true);
    }

    private int FindNearest(int n, int n2) {
        int n3 = -1;
        int n4 = 0;
        int n5 = 10000;
        Enumeration enumeration = this.m_Nodes.elements();
        while (enumeration.hasMoreElements()) {
            int[] nArray = (int[])enumeration.nextElement();
            int n6 = Math.abs(nArray[0] - n) + Math.abs(nArray[1] - n2);
            if (n6 < n5) {
                n5 = n6;
                n3 = n4;
            }
            ++n4;
        }
        return n5 < 4 * this.m_r ? n3 : -1;
    }

    public void InitReset() {
        int n;
        int n2;
        this.m_Announce = null;
        this.bDragging = false;
        this.m_Nodes.removeAllElements();
        this.m_Links.removeAllElements();
        this.Items.removeAllElements();
        Dimension dimension = this.getSize();
        int n3 = Math.min(dimension.width, dimension.height);
        int n4 = n3 / 6;
        int n5 = 4;
        int n6 = 5;
        int n7 = (dimension.width - (n5 - 1) * n4) / 2;
        int n8 = (dimension.height - (n6 - 1) * n4) / 2;
        for (n2 = 0; n2 < n6; ++n2) {
            for (n = 0; n < n5; ++n) {
                int[] nArray = new int[]{n7 + n * n4, n8 + n2 * n4, 0, Math.random() < 0.5 ? 0 : 1};
                this.m_Nodes.addElement(nArray);
            }
        }
        for (n2 = 0; n2 < n6; ++n2) {
            for (n = 0; n < n5 - 1; ++n) {
                this.AddFullLink(n2 * n5 + n, n2 * n5 + n + 1);
            }
        }
        for (n2 = 0; n2 < n6 - 1; ++n2) {
            for (n = 0; n < n5; ++n) {
                this.AddFullLink(n2 * n5 + n, (n2 + 1) * n5 + n);
            }
        }
        for (n2 = 0; n2 < n6 - 1; ++n2) {
            for (n = 1; n < n5; ++n) {
                this.AddFullLink(n2 * n5 + n, (n2 + 1) * n5 + n - 1);
            }
        }
        this.DrawFixed(this.m_BGraph);
    }

    private void AddFullLink(int n, int n2) {
        this.AddLink(n, n2);
        int[] nArray = (int[])this.m_Nodes.elementAt(n);
        nArray[2] = nArray[2] + 1;
        int[] nArray2 = (int[])this.m_Nodes.elementAt(n2);
        nArray2[2] = nArray2[2] + 1;
    }

    public void Reset() {
        this.m_Announce = null;
        this.bDragging = false;
        this.m_Nodes.removeAllElements();
        this.m_Links.removeAllElements();
        this.Items.removeAllElements();
        this.DrawFixed(this.m_BGraph);
    }

    private void DrawFixed(Graphics graphics) {
        Object object;
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        Object object2 = this.m_Links.elements();
        while (object2.hasMoreElements()) {
            object = this.getForeground();
            graphics.setColor((Color)object);
            int[] nArray = (int[])object2.nextElement();
            if (nArray[0] == nArray[1]) {
                graphics.drawOval(((int[])this.m_Nodes.elementAt(nArray[0]))[0], ((int[])this.m_Nodes.elementAt(nArray[0]))[1] - this.m_R, 2 * this.m_R, 2 * this.m_R);
            } else {
                int[] nArray2;
                int[] nArray3 = (int[])this.m_Nodes.elementAt(nArray[0]);
                object = nArray3[3] == (nArray2 = (int[])this.m_Nodes.elementAt(nArray[1]))[3] ? Color.red : Color.blue;
                graphics.setColor((Color)object);
                graphics.drawLine(nArray3[0], nArray3[1], nArray2[0], nArray2[1]);
            }
            if (nArray[2] <= 1) continue;
            int n = (((int[])this.m_Nodes.elementAt(nArray[0]))[0] + ((int[])this.m_Nodes.elementAt(nArray[1]))[0]) / 2;
            int n2 = (((int[])this.m_Nodes.elementAt(nArray[0]))[1] + ((int[])this.m_Nodes.elementAt(nArray[1]))[1]) / 2;
            if (nArray[0] == nArray[1]) {
                n += 2 * this.m_R;
            }
            graphics.setColor(this.getBackground());
            graphics.fillRect(n - 6, n2 - 6, 12, 12);
            graphics.setColor((Color)object);
            graphics.drawString("" + nArray[2], n - 2, n2 + 4);
        }
        graphics.setColor(this.getForeground());
        object = this.m_Nodes.elements();
        while (object.hasMoreElements()) {
            object2 = (int[])object.nextElement();
            graphics.setColor(this.Colors[object2[3]]);
            graphics.fillOval((int)(object2[0] - this.m_r), (int)(object2[1] - this.m_r), 2 * this.m_r, 2 * this.m_r);
            graphics.setColor(Color.gray);
            graphics.drawOval((int)(object2[0] - this.m_r), (int)(object2[1] - this.m_r), 2 * this.m_r, 2 * this.m_r);
        }
    }

    public void Pop() {
        if (this.Items.isEmpty()) {
            return;
        }
        Integer n = (Integer)this.Items.pop();
        int[] nArray = (int[])this.m_Links.elementAt(n);
        if (nArray[2] == 1) {
            this.m_Links.remove(nArray);
        } else {
            nArray[2] = nArray[2] - 1;
        }
        int[] nArray2 = (int[])this.m_Nodes.elementAt(nArray[0]);
        int[] nArray3 = (int[])this.m_Nodes.elementAt(nArray[1]);
        nArray2[2] = nArray2[2] - 1;
        nArray3[2] = nArray3[2] - 1;
        if (nArray2[2] == 0) {
            this.m_Nodes.removeElement(nArray2);
        }
        if (nArray3[2] == 0 && nArray2 != nArray3) {
            this.m_Nodes.removeElement(nArray3);
        }
        this.DrawFixed(this.m_BGraph);
        this.m_Parent.m_panel.Pop.setEnabled(!this.Items.isEmpty());
        this.m_Parent.m_panel.Move.setEnabled(!this.m_Nodes.isEmpty());
    }
}

